<?php

App::uses('AppModel', 'Model');
App::uses('CakeEvent', 'Event');

App::uses('BlowfishPasswordHasher', 'Controller/Component/Auth');

class User extends AppModel
{

    public $hasMany = array( 'Link', 'Page', 'Stat' );
    public $belongsTo = array( 'Plan' );
    public $validate = array(
        'username' => array(
            'alphaNumeric'  => array(
                'rule'       => 'alphaNumeric',
                'required'   => true,
                'allowEmpty' => false,
                'on'         => 'create',
                'message'    => 'A username is required'
            ),
            'minLength'     => array(
                'rule'    => array( 'minLength', 5 ),
                'message' => 'Username must be at least 6 characters long'
            ),
            'checkReserved' => array(
                'rule'    => 'checkReserved',
                'message' => 'This username is a reserved word.'
            ),
            'isUnique'      => array(
                'rule'    => 'isUnique',
                'message' => 'The username has already been taken.'
            )
        ),
        'password'         => array(
            'minLength' => array(
                'rule'       => array( 'minLength', 6 ),
                'allowEmpty' => false,
                'message'    => 'Passwords must be at least 6 characters long.'
            ),
        ),
        'confirm_password' => array(
            'validatePasswordConfirm' => array(
                'rule'       => 'validatePasswordConfirm',
                'allowEmpty' => false,
                'message'    => 'Passwords do not match.'
            )
        ),
        'current_password' => array(
            'notBlank'                  => array(
                'rule'    => 'notBlank',
                'message' => 'Please enter your current password.'
            ),
            'validate_current_password' => array(
                'rule'    => 'validate_current_password',
                'message' => 'Passwords do not match'
            )
        ),
        'first_name'       => array(
            
        ),
        'last_name'        => array(
            
        ),
        'country'          => array(
            'inList'   => array(
                'rule'    => array( 'checkContry' ),
                'message' => 'Choose a valid country.',
                'allowEmpty' => true
            )
        ),
        'email'            => array(
            'email'    => array(
                'rule'    => 'email',
                'message' => 'Please enter a valid email address.'
            ),
            'isUnique' => array(
                'rule'    => 'isUnique',
                'message' => 'This username has already been taken.'
            )
        ),
        'confirm_email'    => array(
            'notBlank' => array(
                'rule'    => 'notBlank',
                'message' => 'A password is required'
            ),
            'match'    => array(
                'rule'    => 'validateemailConfirm',
                'message' => 'Emails do not match.'
            )
        ),
        'redirection_type' => array(
            'notBlank' => array(
                'rule' => 'notBlank',
            ),
            'inList'   => array(
                'rule'    => array( 'inList', array( '1', '2' ) ),
                'message' => 'Choose a valid value.',
            ),
        ),
        'account_type'     => array(
            'notBlank' => array(
                'rule' => 'notBlank',
            ),
            'inList'   => array(
                'rule'    => array( 'inList', array( 'Free', 'Admin', 'Demo' ) ),
                'message' => 'Choose a valid account type.',
            ),
        ),
        'status'           => array(
            'notBlank' => array(
                'rule' => 'notBlank',
            ),
            'inList'   => array(
                'rule'    => array( 'inList', array( 'Active', 'Inactive', 'Banned' ) ),
                'message' => 'Choose a valid status.',
            ),
        ),
        'feed'             => array(
            'url' => array(
                'rule'       => 'url',
                'allowEmpty' => true,
            ),
        ),
        'timer'            => array(
            'naturalNumber' => array(
                'rule'       => 'naturalNumber',
                //'required' => true,
                'allowEmpty' => true,
                'message'    => 'Please supply a valid natural number.'
            ),
            'range'         => array(
                'rule'       => array( 'range', 0, 61 ),
                //'required' => true,
                'allowEmpty' => true,
                'message'    => 'Please enter a number between 1 and 60'
            )
        )
    );

    function check_current_email($check)
    {
        if ($check[ 'email' ] == $_SESSION[ 'Auth' ][ 'User' ][ 'email' ]) {
            return false;
        }
        return true;
    }

    function checkReserved($check)
    {
        // http://book.cakephp.org/2.0/en/models/data-validation.html#custom-validation-rules
        // $check will have value: array('field' => 'some-value')
        // Another method
        // $data array is passed using the form field name as the key
        // have to extract the value to make the function generic
        // $value = $check['username'];
        $value              = array_values($check);
        $reserved_usernames = explode(',', Configure::read('Option.reserved_usernames'));
        if (in_array($value[ 0 ], $reserved_usernames)) {
            return false;
        }
        return true;
    }

    public function checkContry()
    {
        $countries = get_countries();
        return array_key_exists($this->data[ $this->alias ][ 'country' ], $countries);
    }

    function validatePasswordConfirm($data)
    {
        if ($this->data[ 'User' ][ 'password' ] !== $data[ 'confirm_password' ]) {
            return false;
        }
        return true;
    }

    function validate_current_password($check)
    {
        $passwordHasher = new BlowfishPasswordHasher();
        $user           = $this->findById($_SESSION[ 'Auth' ][ 'User' ][ 'id' ]);

        if (!$passwordHasher->check($check[ 'current_password' ], $user[ 'User' ][ 'password' ])) {
            return false;
        }
        return true;
    }

    function validateEmailConfirm($check)
    {
        if ($this->data[ 'User' ][ 'email' ] !== $check[ 'confirm_email' ]) {
            return false;
        }
        return true;
    }

    public function isOwnedBy($userEditId, $userId)
    {
        return $this->field('User.id', array( 'User.id' => $userEditId )) === $userId;
    }

    public function beforeValidate($options = array())
    {
        return true; //this is required, otherwise validation will always fail
    }

    public function beforeSave($options = array())
    {

        if (isset($this->data[ $this->alias ][ 'password' ]) && !empty($this->data[ $this->alias ][ 'password' ])) {
            $passwordHasher                       = new BlowfishPasswordHasher();
            $this->data[ $this->alias ][ 'password' ] = $passwordHasher->hash($this->data[ $this->alias ][ 'password' ]);
        } else {
            unset($this->data[ $this->alias ][ 'password' ]);
        }
        if (isset($this->data[ $this->alias ][ 'confirm_password' ])) {
            unset($this->data[ $this->alias ][ 'confirm_password' ]);
        }
        if (isset($this->data[ $this->alias ][ 'current_password' ])) {
            unset($this->data[ $this->alias ][ 'current_password' ]);
        }
        return true;
    }

    public function afterSave($created, $options = array())
    {
        /*
          $event = new CakeEvent('Model.User.created', $this, array(
          'id' => $this->id,
          'data' => $this->data[$this->alias]
          ));
          $this->getEventManager()->dispatch($event);
         */
    }

    public function afterDelete()
    {
        App::uses('ClassRegistry', 'Utility');

        $linkModel      = ClassRegistry::init('Link');
        $statModel      = ClassRegistry::init('Stat');
        $bundleModel    = ClassRegistry::init('Bundle');
        $activitykModel = ClassRegistry::init('Activity');

        $linkModel->deleteAll(array( 'Link.user_id' => $this->id ), false);
        $statModel->deleteAll(array( 'Stat.user_id' => $this->id ), false);
        $bundleModel->deleteAll(array( 'Bundle.user_id' => $this->id ), false);
        $activitykModel->deleteAll(array( 'Activity.user_id' => $this->id ), false);
    }

    /**
     * http://stackoverflow.com/a/21769518/1794834
     */
    public function api_authenticate($data)
    {
        $user = $this->find('first', array(
            'conditions' => array(
                'User.status'   => 'Active',
                'User.username' => $data[ 'username' ],
                'User.api_key'  => $data[ 'api_key' ],
            ),
        ));
        if (!$user) {
            return false;
        }
        return $user;
    }
}
